%% meet.m
 
%% Function to compute the meet of "n" type-1 fuzzy sets under minimum  
%% t-norm, using Theorem A-2 in the book Uncertain Rule-Based Fuzzy 
%% Logic Systems: Introduction and New Directions, by Jerry M. Mendel, 
%% and published by Prentice-Hall, 2000.

%% Written by Nilesh N. Karnik - July 21,1998
%% For use with MATLAB 5.1 or higher.

%% Outputs : "out" and "mem" (vectors) are, respectively, 
%% the domain and the memberships of the result of the "meet" operation. 
 
%% Inputs : "x" is an "m" vector containing the domain elements of the 
%% type-1 sets participating in the meet operation. All the sets are 
%% supposed to have the same domain. This is not at all a restrictive 
%% assumption, as the sets we deal with are generally subsets of the 
%% real line. "Y" is an "n x m" vector containing the membership grades 
%% of the "n" type-1 fuzzy sets. 
 
%% Note : Only the minimum t-norm is used here. For the product t-norm
%% use "extend_binary.m" repeatedly, with " 'op' = 'mult' ", or use gaussian_meet.m
%% if all the participating sets are type-1 Gaussians.



function[out,mem] = meet(x,Y)

[n,m] = size(Y) ;  

for i1 = 1 : n,
    in1 = find(Y(i1,:) == 1) ;
    v1(i1) = in1(1) ;
end  %%% for i1 

[v,in2] = sort(v1) ;
Y1 = Y(in2,:) ;

out = x ;

mem(1:v(1)) = max(Y1(:,1:v(1))) ;

for i1 = 1 : n-1,
    if i1 > 1 ,
       mem(v(i1)+1 : v(i1+1)) = min(Y1(1:i1, v(i1)+1 : v(i1+1))) ;
    else
       mem(v(i1)+1 : v(i1+1)) = Y1(1, v(i1)+1 : v(i1+1)) ;
    end   % if i1
end  %% for i1

mem(v(n)+1 : m) = min(Y1(: , v(n)+1 : m)) ;   

return ;











